#ifndef NUMERICS_H
#define NUMERICS_H

#include "struktury.h"                                                          //komplexnější proměnné a objekty

QString to_time(qint64 t);                                                      //převod tisícin sekundy na čas
real pw(real x, int n);                                                         //celočíselná mocnina
real der(const uchar (&g)[arl], const char &γ, f_vec b);                        //numerická derivace postfixu
f_vec rungekuta(f_vec (*f)(f_vec u, tensor_3 &c), f_vec u, tensor_3 c, real h); //řešení ODR
void RGBtoHSL(int r, int g, int b, double& h, double& s, double& l);            //převod barev na HSL
void HSLtoRGB(real h, double s, double l, int& r, int& g, int& b);              //převod HSL na barvy
real l_pol(real x, int r, int g, int b);                                        //Lagrangeův polynom 8 řádu
uint32_t sh_col(uint32_t col, real a);                                          //posun barev o redshift a
uint32_t bm_col(uint32_t col, real δ);                                          //zjasnění barev o beaming δ
uint32_t av_col(uint32_t col1, uint32_t col2);                                  //vážený průměr barev (průhlednost akrečního disku)
void invMatrix(real (&m)[4][4]);                                                //výpočet inverzní matice
real dot_p(real (&m)[4], real (&n)[4], f_vec x);                                //skalární součin v g_{\nu\nu}
void norm(real (&v)[4], f_vec x);                                               //normalizace čtyřvektoru v g_}\mu\nu}
void ortonormalize(real (&m)[4][4], f_vec x);                                   //Gram-Schmidtova ortogonalizace

#endif // NUMERICS_H
